                TITLE   faa1x16a
                .686
                .MODEL  FLAT
;
_ACODE          SEGMENT	PARA USE32 PUBLIC 'CODE'
                ASSUME  CS:_ACODE
                PUBLIC  _faa1x16a_       			; Entry point name

_faa1x16a_    proc    near
    push   ebp						;Push ebp onto the stack
    mov    ebp,			esp			;move esp which contains input data into ebp for use
    push   ecx						;preserve ecx
    push   ebx						;preserve ebx
    push   esi						;preserve esi
    push   edi						;preserve edi
    add    			[dword ptr [ebp+8]], 32	;Moves the pointer 32 elements into dt1 array
    add    			[dword ptr [ebp+12]],32	;Moves the pointer 32 elements into dt2 array
    mov    edx,                 [dword ptr [ebp+8]]	;Makes edx a pointer to source array (dt1)
    mov    esi,                 [dword ptr [ebp+12]]	;Makes esi a pointer to destination array (dt2)
    mov    edi,                  edx			;Copy contents of edx (DT1) to edi
    mov	   ebx,			[dword ptr [ebp+16]]	;Make ebx a pointer to the length variable
    add	   edx, 		[ebx]			;Make edx point to the end of the source array (dt1) 
    sub    edx,                  4			;Move the edx pointer back by 4 for endianness.
    mov   [dword ptr [ebp-4]],   0FFFFFFFFH		;Initialize flg to no carries yet
    mov    ebx,                  0			;Use ebx for carries, none to start
f2a:
    mov    eax,                 [edx]			;Load four in-order bytes from left
    bswap  eax						;Reverse them
    sub    edx,                  4			;Decrement left-side Pointer (edx)
    add    eax,                 [edi]			;Add four in-order bytes from the right
    add    eax,                  ebx			;Add the previous carry none to start
    add    edi,                  4			;Increment right side pointer (edi)
    add    eax,                  076F6F6F6H		;Apply bit mask
    mov    ebx,                  eax			;Move eax to a scratch register ebx
    and    ebx,                  060606060H		;Leave high nibbles that did not need a carry set to 6
    and   [dword ptr [ebp-4]],   ebx			;Move carries to temp space
    shr    ebx,                  4			;Move into low nibles
    sub    eax,                  ebx			;Remove extra 6 from values that didn't carry
    mov    ebx,                  eax			;Copy results back to ebx
    and    eax,                  00F0F0F0FH		;Clear high nibbles
    shr    ebx,                  31			;Shift inter dword carry for addition to next 4 digits
    mov    ecx,                 [dword ptr [ebp+8]]	;Makes ecx a pointer to source array (dt1)
    mov   [esi],                 eax			;Move results to destination array
    sub    ecx,                  4			;Decrement left-side Pointer (ecx)
    add    esi,                  4			;Incerment destination array
    cmp    edx,                  ecx			;See if we have finished the array
    jge    f2a						;If no the do another pass
    xor   [dword ptr [ebp-4]],   060606060H		;??? Why set high nibbles to 6?

    mov    eax,                  dword ptr [ebp-4]
    pop    edi
    pop    esi
    pop    ebx
    pop    ecx
    mov    esp,ebp 					   
    pop    ebp
    ret
_faa1x16a_    endp  					;End of procedure

                 
_ACODE          ENDS                    		; End of segment
                END