#include<math.h>
#include<stdio.h>
#include<stdlib.h>
#include<windows.h>
#include"isftool.rh"


#define ISFTVERS "v2.757\0\0"

#define POP_MODE (MB_OK|MB_TOPMOST|MB_APPLMODAL)

#define MAX_STRN (4096)



char Fnam[MAX_STRN]="\0\0"; // Current ISF file to use.  OH how I hate globals.



int get_filename(char *fnam, int mode)
// pops up the standard windows file-selection dialog to get a filename
{
    int          resl;
    OPENFILENAME ofnm;
    DWORD        eror;

    memset(fnam, 0, MAX_STRN);

    if((mode<0)||(mode>1))
    {
        MessageBox(NULL, "Invalid GetSaveFile mode", "Error:", POP_MODE);
        return(FALSE);
    }

    ofnm.lStructSize       = sizeof(OPENFILENAME);
    ofnm.hwndOwner         = NULL;
    ofnm.hInstance         = NULL;
    ofnm.lpstrFilter       = "All Files\0*.*\0\0";
    ofnm.lpstrCustomFilter = NULL;
    ofnm.nMaxCustFilter    = 0;
    ofnm.nFilterIndex      = 1;
    ofnm.lpstrFile         = (LPSTR)fnam;
    ofnm.nMaxFile          = MAX_STRN;
    ofnm.lpstrFileTitle    = NULL;
    ofnm.nMaxFileTitle     = 0;
    ofnm.lpstrInitialDir   = NULL;
    ofnm.nFileOffset       = 0;
    ofnm.nFileExtension    = 0;
    ofnm.lpstrDefExt       = "*";
    ofnm.lCustData         = 0L;
    ofnm.lpfnHook          = NULL;
    ofnm.lpTemplateName    = NULL;

    if(mode==0)
    {
        ofnm.lpstrTitle="Open a file";
        ofnm.Flags=OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_READONLY;
        resl=GetOpenFileName(&ofnm);
    }
    if(mode==1)
    {
        ofnm.lpstrTitle="Save file as";
        ofnm.Flags=OFN_NOREADONLYRETURN|OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;
        resl=GetSaveFileName(&ofnm);
    }

    if(resl!=TRUE)
    {
        eror=CommDlgExtendedError();
        if(eror!=0)
        {
            if(mode==0) sprintf(fnam, "GetOpenFileName failed\n(error %d)", eror);
            if(mode==1) sprintf(fnam, "GetSaveFileName failed\n(error %d)", eror);
            MessageBox(NULL, fnam, "Error:", POP_MODE);
        }
        memset(fnam, 0, MAX_STRN);
        return(FALSE);
    }

    return(TRUE);
}


void setcolor(HDC devc, int colr)
// sets the current line-drawing color
{
    HPEN oldp;
    oldp=SelectObject(devc, CreatePen(PS_SOLID,0,colr));
    DeleteObject(oldp);
}


void line(HDC dc, int x1, int y1, int x2, int y2)
// draws a line from (x1, y1) to (x2, y2).
{
    MoveToEx(dc, x1, y1, NULL);
    LineTo(dc, x2, y2);
}


void save_bmp_file(HWND wind, char *sbuf)
// saves the drawing area of the screen to a Windows bitmap (.bmp) file
{
    FILE *fout;
    int      i;
    int      j;
    int      k;
    int   xsiz;
    int   ysiz;
    int   temp;
    int   totl;
    char  ctmp;
    short stmp;
    long  ltmp;
    HDC   devc;
    RECT  rect;
    char  nout[MAX_STRN];

    get_filename(nout, 1);
    if(nout==FALSE)
    {
        sprintf(sbuf, "No valid output files specified\nImage not saved\0");
        return;
    }

    devc=GetWindowDC(wind);
    GetWindowRect(wind, &rect);
    rect.right-=(rect.left+10); rect.left=24;
    rect.bottom-=(rect.top+9); rect.top=135;
    xsiz=(rect.right-rect.left);
    ysiz=(rect.bottom-rect.top);

    if((fout=fopen(nout,"wb"))==NULL)
    {
        sprintf(sbuf, "Cannot open \"%s\" for output\0", nout);
        return;
    }

    temp=(xsiz*ysiz*3)+54;

    ctmp='B';  fwrite(&ctmp, 1, 1, fout);
    ctmp='M';  fwrite(&ctmp, 1, 1, fout);
    ltmp=temp; fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=54;   fwrite(&ltmp, 4, 1, fout);
    ltmp=40;   fwrite(&ltmp, 4, 1, fout);
    ltmp=xsiz; fwrite(&ltmp, 4, 1, fout);
    ltmp=ysiz; fwrite(&ltmp, 4, 1, fout);
    stmp=1;    fwrite(&stmp, 2, 1, fout);
    stmp=24;   fwrite(&stmp, 2, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);
    ltmp=0;    fwrite(&ltmp, 4, 1, fout);

    totl=54;
    for(i=(ysiz-1);i>=0;i--)
    {
        k=0;
        for(j=0;j<xsiz;j++)
        {
            temp=GetPixel(devc, j+rect.left, i+rect.top); totl+=3; k+=3;
            ctmp=(char)((temp>>16)&0x000000FF);  fwrite(&ctmp, 1, 1, fout);
            ctmp=(char)((temp>> 8)&0x000000FF);  fwrite(&ctmp, 1, 1, fout);
            ctmp=(char)((temp    )&0x000000FF);  fwrite(&ctmp, 1, 1, fout);
        }
        ctmp=0;
        while((k%4)>0)
        {
            fwrite(&ctmp, 1, 1, fout);
            k++;
        }
    }

    fflush(fout); fclose(fout);
    ReleaseDC(wind, devc);

    sprintf(sbuf, "Wrote %d bytes\nto file \"%s\"\0", totl, nout);
}


double autocorr(double data[], int size, int lagv)
// Computes the lagged autocorrelation of the passed vector
{
    int    i;
    double mean;
    double cov0;
    double covn;

    if(lagv<10) return(0.0);

    mean=0.0; for(i=0;i<size;i++) mean+=data[i]; mean/=(double)size;
    cov0=0.0; for(i=0;i<size;i++) cov0+=(data[i]-mean)*(data[i]-mean);
    covn=0.0; for(i=lagv;i<size;i++) covn+=(data[i]-mean)*(data[i-lagv]-mean);
    cov0/=(double)size; covn/=(double)size; covn/=cov0;

    return(covn);
}


int get_best_width(HWND wind, char *fnam)
// Determines, via the autocorrelation function, the "best"
// column width to use, in the global between-line LSE sense
{
    FILE   *finp;
    double *data;
    int     i;
    int     temp;
    int     totl;
    int     used;
    int     blag;
    double  best;
    double  resl;
    HDC     devc;
    RECT    rect;
    char    strn[MAX_STRN];

    devc=GetWindowDC(wind);
    GetWindowRect(wind, &rect);
    rect.right-=(rect.left+10); rect.left=24;
    rect.bottom-=(rect.top+9); rect.top=135;
    totl=(rect.right-rect.left)*(rect.bottom-rect.top);

    data=(double *)malloc(((totl+512)&0x0FFFFFC0)*sizeof(double));
    if(data==NULL) return(1);
    for(i=0;i<((totl+512)&0x0FFFFFC0);i++) data[i]=0.0;

    used=0;
    if((finp=fopen(fnam,"rt"))==NULL) return(1);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    while((used<=totl)&&(fgets(strn,MAX_STRN-1,finp)!=NULL))
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if(used>=totl) break;
            if((strn[i]<'0')||(strn[i]>'9')) break;
            data[used++]=(0.9-(0.2*(double)(strn[i]-'0')));
            data[used++]=(double)(strn[i]-'0');
        }
    }
    fclose(finp);

    totl=(rect.right-rect.left); best=(-2.0); blag=1;
    if(used<((rect.right-rect.left)*3)) totl=(used/3);
    for(i=1;i<totl;i++)
    {
        resl=autocorr(data, used-3, i);
        if(resl>best) {best=resl; blag=i;}
        temp=(int)((double)i*((double)((rect.right-rect.left)-4))/(double)totl);
        temp+=rect.left+2;
        setcolor(devc, 0x007FFF7F);
        line(devc, temp, rect.bottom-3, temp, rect.bottom-11);
        Sleep(1); // yield CPU to make this less unfriendly
    }

    if(data!=NULL) free(data);
    ReleaseDC(wind, devc);
    return(blag);
}


double one_dft(char d[], int n, int j)
// Calculates the Discrete Fourier Transform (power only) at a single frequency
{
    int    k;
    double c;
    double s;
    double t;
    static double tcos[4096];
    static double tsin[4096];

    if(d==NULL)
    {
        t=(M_PI*2.0)/4096.0;
        for(k=0;k<4096;k++)
        {
            tcos[k]=cos(t*(double)k);
            tsin[k]=sin(t*(double)k);
        }
        return(0.0);
    }

    t=(4096.0*((double)j/(double)n));

    c=0.0; s=0.0;
    for(k=0;k<n;k++)
    {
        c+=tcos[(int)(t*k)&0x0FFF]*(0.9-(0.2*(double)d[k]));
        s+=tsin[(int)(t*k)&0x0FFF]*(0.9-(0.2*(double)d[k]));
    }

    t=((c*c)+(s*s))/((double)n*(double)n);

    return(t);
}


void do_dft(HDC devc, char *fnam, double *resl, int bins, int xmin, int ymax)
// Calculates a partial DFT spectrogram
{
    int     i;
    int     totl;
    FILE   *finp;
    char   *data;
    double  temp;
    char    strn[MAX_STRN];

    for(i=0;i<bins;i++) resl[i]=0.0;

    totl=0;
    if((finp=fopen(fnam,"rt"))==NULL) return;
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            totl++;
        }
    }
    fclose(finp);

    if((data=(char *)malloc((totl+512)&0x0FFFFFC0))==NULL) return;
    memset(data, 0, ((totl+512)&0x0FFFFFC0));

    totl=0;
    if((finp=fopen(fnam,"rt"))==NULL)
    {
        if(data!=NULL) free(data);
        return;
    }
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            data[totl++]=(char)(strn[i]-'0');
        }
    }
    fclose(finp);

    for(i=0;i<bins;i++)
    {
        temp=(((double)(totl>>1))/(double)bins);
        temp=((temp*(double)i)+(temp*(double)(i+1)))/2;
        resl[i]=one_dft(data, totl, (int)temp);
        setcolor(devc, 0x007FFF7F);
        line(devc, xmin+i, ymax, xmin+i, ymax-8);
        Sleep(1); // yield CPU to make this less unfriendly
    }

    if(data!=NULL) free(data);
}


void show_dft(HWND wind, char *fnam)
// Displays the partial DFT of the ISF file's data
{
    int     i;
    int     bins;
    int     temp;
    HDC     devc;
    RECT    rect;
    double  maxf;
    double  freq[MAX_STRN];

    devc=GetWindowDC(wind);
    GetWindowRect(wind, &rect);
    rect.right-=(rect.left+10); rect.left=24;
    rect.bottom-=(rect.top+9); rect.top=135;
    FillRect(devc, &rect, (HBRUSH)GetStockObject(GRAY_BRUSH));

    bins=((rect.right-rect.left)-4);
    if(bins>=MAX_STRN) bins=(MAX_STRN-1);
    do_dft(devc, fnam, freq, bins, rect.left+2, rect.bottom-3);

    maxf=0.0;
    for(i=0;i<bins;i++) {if(freq[i]>maxf) maxf=freq[i];}
    if(maxf==0.0) maxf=1.0;
    maxf=(double)((rect.bottom-rect.top)-5)/maxf;
    for(i=0;i<bins;i++) freq[i]*=maxf;

    for(i=0;i<bins;i++)
    {
        temp=rect.left+i+2;
        setcolor(devc, 0x007F7F7F);
        line(devc, temp, rect.bottom-2, temp, rect.bottom-12);
        setcolor(devc, 0x00FFFFFF);
        line(devc, temp, rect.bottom-3, temp, (rect.bottom-3)-(int)freq[i]);
    }

    ReleaseDC(wind, devc);
}


int verify_checksum(int val1, int val2, int iter)
// Given two numbers, an iteration, and a MOD-9 checksum,
// verifies that the latter number can result from the
// former after the selected number of iterations.
{
    int i;
    int temp;
    int flag;

    flag=0;
    if(val1==0)
    {
        if(val1!=val2) flag=2;
    }
    else if((val1==3)||(val1==6))
    {
        temp=val1;
        for(i=0;i<(iter%2);i++) temp=((temp*2)%9);
        if(temp!=val2) flag=1;
        if((val2!=6)&&(val2!=3)) flag=2;
    }
    else
    {
        temp=val1;
        for(i=0;i<(iter%6);i++) temp=((temp*2)%9);
        if(temp!=val2) flag=1;
        if((val2==0)||(val2==3)||(val2==6)) flag=2;
    }

    return(flag);
}


unsigned short crc16(unsigned char data, unsigned short poly, unsigned short resl)
// Appends one byte to a runing CRC-16 calculation
{
    int i;
    resl^=(unsigned short)(((unsigned short)data)<<8);
    for(i=8;i>0;--i)
    {
        if(resl&0x8000) resl=(unsigned short)((resl<<1)^poly);
        else            resl=(unsigned short)((resl<<1));
    }
    return (resl);
}


unsigned short file_crc16(char *fnam)
// Calculates the CRC-16 of the ISF file
{
    FILE           *finp;
    unsigned char   crcd;
    unsigned short  crcr;

    if((finp=fopen(fnam,"rb"))==NULL) return(0xFFFF);

    crcd='0'; crcr=0xFFFF;
    while((fread(&crcd,1,1,finp)==1)&&(crcd>=' '));
    while((fread(&crcd,1,1,finp)==1)&&(crcd>=' '));
    while(fread(&crcd,1,1,finp)==1) crcr=crc16(crcd, 0x1021, crcr);

    fclose(finp);

    return(crcr);
}


void check_file(char *sbuf, char *fnam)
// Verifies the integrity of an ISF file.
// Not very "robust", in the sense that a badly corrupt
// file will propbably make this function choke.
{
    FILE          *finp;
    int            i;
    int            iter;
    int            lmax;
    int            leng;
    int            csum;
    int            corg;
    int            crcv;
    unsigned char  data;
    char           dbeg[MAX_STRN];
    char           strn[MAX_STRN];
    char           stmp[MAX_STRN];

    crcv=file_crc16(fnam);
    if(crcv==0x0000FFFF)
    {
        sprintf(stmp, "Error:\t\tCannot open file \"%s\"", fnam);
        strcat(sbuf, stmp);
        return;
    }

    if((finp=fopen(fnam,"rt"))==NULL)
    {
        sprintf(stmp, "Error:\t\tCannot open file \"%s\"", fnam);
        strcat(sbuf, stmp);
        return;
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tUnexpected EOF encountered");
        strcat(sbuf, stmp);
        return;
    }
    if(crcv!=(int)strtod(strn+16,NULL))
    {
        sprintf(stmp, "Warning:\tIncorrect CRC-16 (%04X)", (int)strtod(strn+16,NULL));
        strcat(sbuf, stmp);
        sprintf(stmp, " in file, should have %04X\n", crcv);
        strcat(sbuf, stmp);
    }
    else
    {
        sprintf(stmp, "Okay:\t\tFile has the correct CRC-16, %04X\n", crcv);
        strcat(sbuf, stmp);
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tUnexpected EOF encountered");
        strcat(sbuf, stmp);
        return;
    }
    for(i= 0;i<MAX_STRN;i++) dbeg[i]=0;
    for(i=18;i<MAX_STRN;i++) if((strn[i]<'0')||(strn[i]>'9')) break;
    corg=0; leng=i-1;
    for(i=leng;i>=18;i--)
    {
        dbeg[i-18]=(char)(strn[i]);
        data=(char)(strn[i]-'0');
        corg=((corg+data)%9);
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tUnexpected EOF encountered");
        strcat(sbuf, stmp);
        return;
    }
    iter=(int)strtod(strn+17, NULL);
    if(iter<0)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tInvalid iteration (%d) recorded in file", iter);
        strcat(sbuf, stmp);
        return;
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tUnexpected EOF encountered");
        strcat(sbuf, stmp);
        return;
    }
    lmax=(int)strtod(strn+17, NULL);
    if(lmax<0)
    {
        fclose(finp);
        sprintf(stmp, "Error:\t\tInvalid length (%d) recorded in file", lmax);
        strcat(sbuf, stmp);
        return;
    }

    csum=0; leng=0;
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            data=(char)(strn[i]-'0');
            csum=((csum+data)%9);
            leng++;
        }
    }

    fclose(finp);

    if(leng!=lmax)
    {
        sprintf(stmp, "Warning:\tReported length (%d) ", lmax);
        strcat(sbuf, stmp);
        sprintf(stmp, "differs from actual length (%d)\n", leng);
        strcat(sbuf, stmp);
    }
    else
    {
        sprintf(stmp, "Okay:\t\tReported length (%d)", lmax);
        strcat(sbuf, stmp);
        sprintf(stmp," equals actual length (%d)\n", leng);
        strcat(sbuf, stmp);
    }


    csum=verify_checksum(corg, csum, iter);
    if(csum!=0)
    {
        sprintf(stmp, "Warning:\tMOD-9 checksum (%d) failed - ", csum);
        strcat(sbuf, stmp);
        sprintf(stmp, "The stored %d-digit number\n\t\tcannot ", leng);
        strcat(sbuf, stmp);
        if(csum==1)
        {
            sprintf(stmp, "occur on the stored iteration (%d)", iter);
            strcat(sbuf, stmp);
        }
        if(csum==2)
        {

            sprintf(stmp, "result from the stored starting value (%s)", dbeg);
            strcat(sbuf, stmp);
        }
    }
    else
    {
        sprintf(stmp, "Okay:\t\tMOD-9 checksum (%d) passed", csum);
        strcat(sbuf, stmp);
    }
}


void show_data(HWND wind, char *fnam, int cols, int rows)
// Display the data from and ISF file in a rectangular block
{
    int     i;
    int     j;
    int     k;
    int     xmid;
    int     ymid;
    int     temp;
    FILE   *finp;
    HDC     devc;
    RECT    rect;
    char    strn[MAX_STRN];

    devc=GetWindowDC(wind);
    GetWindowRect(wind, &rect);
    finp=fopen(fnam, "rt");
    rect.right-=(rect.left+10); rect.left=24;
    rect.bottom-=(rect.top+9); rect.top=135;
    xmid=(rect.left+rect.right)>>1;
    ymid=(rect.top+rect.bottom)>>1;

    FillRect(devc, &rect, (HBRUSH)GetStockObject(GRAY_BRUSH));

    if(finp==NULL)
    {
        for(i=(-100);i<=100;i++)
        {
            for(j=(-100);j<=100;j++)
            {
                temp=abs(abs(i)-abs(j));
                if(temp==0) SetPixelV(devc, xmid+i, ymid+j, 0x000000F0);
                if(temp==1) SetPixelV(devc, xmid+i, ymid+j, 0x003030D0);
                if(temp==2) SetPixelV(devc, xmid+i, ymid+j, 0x006060B0);
                if(temp==3) SetPixelV(devc, xmid+i, ymid+j, 0x00909090);
            }
        }
    }
    else
    {
        xmid-=(cols>>1);
        fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
        fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
        fgets(strn, MAX_STRN-1, finp); i=((rect.top+2)-rows); j=0; k=0;
        while(i<(rect.bottom-2))
        {
            if((strn[k]<'0')||(strn[k]>'9'))
            {
                if(fgets(strn,MAX_STRN-1,finp)==NULL) i=rect.bottom;
                k=0;
                if((strn[k]<'0')||(strn[k]>'9')) i=rect.bottom;
            }
            if(i<rect.bottom)
            {
                if((((j-1)+xmid)>rect.left)&&(((j+2)+xmid)<rect.right))
                {
                    if(i>=(rect.top+2))
                    {
                        temp=0x00404040+(0x00101010*(int)(strn[k]-'0'));
                        SetPixelV(devc, j+xmid, i, temp);
                    }
                }
                j++; k++;
                if(j>=cols)
                {
                    j=0;
                    i++;
                }
            }
        }
    }

    fclose(finp);
    ReleaseDC(wind, devc);
}


void show_stats(HWND wind, char *fnam)
// Calculates and displays a few simple statistical measures of the data
{
    FILE   *finp;
    int     i;
    int     j;
    int     k;
    int     totl;
    int     crnt;
    int     prev;
    int     temp;
    double  mom1;
    double  mom2;
    double  mom3;
    double  mom4;
    double  stdv;
    double  scal;
    HDC     devc;
    RECT    rect;
    HFONT   hfnt;
    int     hst1[10];
    int     hst2[10][10];
    char    strn[MAX_STRN];

    for(i=0;i<10;i++)
    {
        hst1[i]=1;
        for(j=0;j<10;j++) hst2[i][j]=1;
    }

    devc=GetWindowDC(wind);
    GetWindowRect(wind, &rect);
    rect.right-=(rect.left+10); rect.left=24;
    rect.bottom-=(rect.top+9); rect.top=135;
    FillRect(devc, &rect, (HBRUSH)GetStockObject(GRAY_BRUSH));

    if((finp=fopen(fnam,"rt"))==NULL)
    {
        prev=(rect.left+rect.right)>>1;
        crnt=(rect.top+rect.bottom)>>1;
        for(i=(-100);i<=100;i++)
        {
            for(j=(-100);j<=100;j++)
            {
                temp=abs(abs(i)-abs(j));
                if(temp==0) SetPixelV(devc, prev+i, crnt+j, 0x000000F0);
                if(temp==1) SetPixelV(devc, prev+i, crnt+j, 0x003030D0);
                if(temp==2) SetPixelV(devc, prev+i, crnt+j, 0x006060B0);
                if(temp==3) SetPixelV(devc, prev+i, crnt+j, 0x00909090);
            }
        }
        return;
    }

    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);

    totl=0; crnt=0; mom1=0.0;
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            prev=crnt;
            crnt=(int)(strn[i]-'0');
            hst1[crnt]++;
            hst2[prev][crnt]++;
            mom1+=(double)crnt;
            totl++;
        }
    }
    if(totl<=0) totl=1;
    mom1/=(double)totl;

    rewind(finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);
    fgets(strn, MAX_STRN-1, finp); fgets(strn, MAX_STRN-1, finp);

    mom2=0.0; mom3=0.0; mom4=0.0;
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            crnt=(int)(strn[i]-'0');
            scal=(double)crnt-mom1;
            mom2+=scal*scal;
            mom3+=scal*scal*scal;
            mom4+=scal*scal*scal*scal;
        }
    }
    mom2/=(double)totl; stdv=sqrt(mom2);
    mom3/=(double)totl; mom3/=(stdv*stdv*stdv);
    mom4/=(double)totl; mom4/=(stdv*stdv*stdv*stdv);

    fclose(finp);

    SetBkMode(devc, OPAQUE);
    SetTextColor(devc, 0x00FFFFFF);
    hfnt=(HFONT)SelectObject(devc, (HFONT)GetStockObject(ANSI_FIXED_FONT));
    SetBkColor(devc, 0x007F7F7F);
    temp=sprintf(strn, " Mean        %+9.4f \0", mom1);
    TextOut(devc, rect.left+8, rect.top+8, strn, temp);
    SetBkColor(devc, 0x008F8F8F);
    temp=sprintf(strn, " Variance    %+9.4f \0", mom2);
    TextOut(devc, rect.left+8, rect.top+24, strn, temp);
    SetBkColor(devc, 0x007F7F7F);
    temp=sprintf(strn, " Std dev     %+9.4f \0", stdv);
    TextOut(devc, rect.left+8, rect.top+40, strn, temp);
    SetBkColor(devc, 0x008F8F8F);
    temp=sprintf(strn, " Skew        %+9.4f \0", mom3);
    TextOut(devc, rect.left+8, rect.top+56, strn, temp);
    SetBkColor(devc, 0x007F7F7F);
    temp=sprintf(strn, " Kurtosis    %+9.4f \0", mom4-3.0);
    TextOut(devc, rect.left+8, rect.top+72, strn, temp);
    SelectObject(devc, hfnt);
    SetBkMode(devc, TRANSPARENT);

    scal=1.0;
    for(i=0;i<10;i++) {if(hst1[i]>(int)scal) scal=(double)hst1[i];}
    scal=(((double)(((rect.bottom-20)-((rect.bottom+rect.top)/2))))/scal);
    temp=sprintf(strn, "Digit Frequency\0");
    TextOut(devc, rect.left+15, ((rect.bottom+rect.top)/2), strn, temp);
    for(i=0;i<10;i++)
    {
        if((i%6)==0) setcolor(devc, 0x00AFBFCF);
        if((i%6)==1) setcolor(devc, 0x00BFCFAF);
        if((i%6)==2) setcolor(devc, 0x00CFAFBF);
        if((i%6)==3) setcolor(devc, 0x00BFAFCF);
        if((i%6)==4) setcolor(devc, 0x00AFCFBF);
        if((i%6)==5) setcolor(devc, 0x00CFBFAF);
        for(j=0;j<10;j++)
        {
            temp=(rect.left+(i*12)+j+6);
            line(devc, temp, rect.bottom-20, temp, rect.bottom-(hst1[i]*scal));
        }
        temp=sprintf(strn, "%01X\0", i);
        TextOut(devc, rect.left+(i*12)+6, rect.bottom-18, strn, temp);
    }

    scal=1.0; k=0;
    for(i=0;i<10;i++)
    {
        for(j=0;j<10;j++) {if(hst2[i][j]>(int)scal) scal=(double)hst2[i][j];}
    }
    scal=(((double)(((rect.bottom-20)-((rect.bottom+rect.top)/2))))/scal);
    temp=sprintf(strn, "Digit Pair Frequency\0");
    TextOut(devc, rect.left+220, ((rect.bottom+rect.top)/2), strn, temp);
    for(i=0;i<10;i++)
    {
        for(j=0;j<10;j++)
        {
            if((k%6)==0) setcolor(devc, 0x00AFBFCF);
            if((k%6)==1) setcolor(devc, 0x00BFCFAF);
            if((k%6)==2) setcolor(devc, 0x00CFAFBF);
            if((k%6)==3) setcolor(devc, 0x00BFAFCF);
            if((k%6)==4) setcolor(devc, 0x00AFCFBF);
            if((k%6)==5) setcolor(devc, 0x00CFBFAF);
            k++;
            temp=(rect.left+(i*32)+(j*3)+132);
            line(devc, temp, rect.bottom-20, temp, rect.bottom-(hst2[i][j]*scal));
        }
        temp=sprintf(strn, " %01X -\0", i);
        TextOut(devc, rect.left+(i*32)+134, rect.bottom-18, strn, temp);
    }

    SetBkMode(devc, OPAQUE);
    ReleaseDC(wind, devc);
}


void check_for_redraw(HWND wind)
// See if the client area needs a redraw, and if
// any controls need their position/size modified
{
    int         flag;
    HWND        hdlg;
    RECT        rcur;
    static RECT rlst;

    GetWindowRect(wind, &rcur);

    flag=FALSE;
    if((rlst.left!=rcur.left)||(rlst.right!=rcur.right)) flag=TRUE;
    if((rlst.top!=rcur.top)||(rlst.bottom!=rcur.bottom)) flag=TRUE;

    if(flag==TRUE)
    {
      hdlg=GetDlgItem(wind, IDC_STATICTEXT1);
      MoveWindow(hdlg, 72, 7, (rcur.right-rcur.left)-86, 47, TRUE);
      hdlg=GetDlgItem(wind, IDC_SCROLLBAR2);
      MoveWindow(hdlg, 6, 112, 12, (rcur.bottom-rcur.top)-144, TRUE);
      hdlg=GetDlgItem(wind, IDC_SCROLLBAR1);
      MoveWindow(hdlg, 72, 90, (rcur.right-rcur.left)-195, 12, TRUE);
      hdlg=GetDlgItem(wind, IDC_STATICTEXT2);
      MoveWindow(hdlg, (rcur.right-rcur.left)-120, 89, 44, 12, TRUE);
      hdlg=GetDlgItem(wind, IDC_BUTTON5);
      MoveWindow(hdlg, (rcur.right-rcur.left)-74, 85, 60, 20, TRUE);
      rlst.left=rcur.left; rlst.right=rcur.right;
      rlst.top=rcur.top; rlst.bottom=rcur.bottom;
      RedrawWindow(wind, 0, 0, RDW_INVALIDATE|RDW_ERASE|RDW_ERASENOW);
    }

}


int CALLBACK dialog1(HWND wind, int mesg, WPARAM wprm, LPARAM lprm)
// The main dialog's message handler
{
    int   temp;
    int   smin;
    int   smax;
    int   flag;
    int   whch;
    HFONT font;
    char  strn[MAX_STRN];

    if(lprm!=lprm) Sleep(1); // stupid compiler errors about forced prototypes

    switch(mesg)
    {
      case WM_DESTROY: case WM_CLOSE:
      {
        PostQuitMessage(0);
        break;
      }
      case WM_INITDIALOG:
      {
        font=CreateFont(15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, FIXED_PITCH, "System");
        SendDlgItemMessage(wind,IDC_STATICTEXT2,WM_SETFONT,(int)font,0);
        sprintf(strn, "ISF Tool %s - \"%s\"\0\0", ISFTVERS, Fnam);
        SetWindowText(wind, strn);
        SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_SETRANGE, 1, MAX_STRN);
        SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_SETPOS, 256, TRUE);
        SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_ENABLE_ARROWS, ESB_ENABLE_BOTH, 0);
        temp=SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_GETPOS, 0, 0);
        sprintf(strn, "%d\0\0", temp);
        SendDlgItemMessage(wind, IDC_STATICTEXT2, WM_SETTEXT, 0, (int)&strn);
        SendDlgItemMessage(wind, IDC_SCROLLBAR2, SBM_SETRANGE, 0, MAX_STRN);
        SendDlgItemMessage(wind, IDC_SCROLLBAR2, SBM_SETPOS, 0, TRUE);
        SendDlgItemMessage(wind, IDC_SCROLLBAR2, SBM_ENABLE_ARROWS, ESB_ENABLE_BOTH, 0);
        break;
      }
      case WM_SIZE: case WM_MOVE:
      {
        check_for_redraw(wind);
        break;
      }
      case WM_HSCROLL: case WM_VSCROLL:
      {
        flag=0;
        if(mesg==WM_HSCROLL) whch=IDC_SCROLLBAR1; else whch=IDC_SCROLLBAR2;
        temp=SendDlgItemMessage(wind, whch, SBM_GETPOS, 0, 0);
        SendDlgItemMessage(wind, whch, SBM_GETRANGE, (int)&smin, (int)&smax);
        switch(LOWORD(wprm))
        {
          case SB_BOTTOM:        temp=smax;         break;
          case SB_ENDSCROLL:     temp=temp; flag=1; break;
          case SB_LINELEFT:      temp--;            break;
          case SB_LINERIGHT:     temp++;            break;
          case SB_PAGELEFT:      temp-=100;         break;
          case SB_PAGERIGHT:     temp+=100;         break;
          case SB_THUMBPOSITION: temp=HIWORD(wprm); break;
          case SB_THUMBTRACK:    temp=HIWORD(wprm); break;
          case SB_TOP:           temp=smin;         break;
          default:               temp=temp;         break;
        }
        if(temp<smin) temp=smin;
        if(temp>smax) temp=smax;
        SendDlgItemMessage(wind, whch, SBM_SETPOS, temp, TRUE);
        if(mesg==WM_HSCROLL)
        {
          temp=SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_GETPOS, 0, 0);
          sprintf(strn, "%d\0\0", temp);
          SendDlgItemMessage(wind, IDC_STATICTEXT2, WM_SETTEXT, 0, (int)&strn);
        }
        if(flag==1) PostMessage(wind, WM_COMMAND, IDC_BUTTON4, 0);
        break;
      }
      case WM_COMMAND:
      {
        switch(LOWORD(wprm))
        {
          case IDC_BUTTON1:
          {
              get_filename(Fnam, 0);
              sprintf(strn, "ISF Tool %s - \"%s\"\0\0", ISFTVERS, Fnam);
              SetWindowText(wind, strn);
              SendDlgItemMessage(wind, IDC_SCROLLBAR2, SBM_SETPOS, 0, TRUE);
              PostMessage(wind, WM_COMMAND, IDC_BUTTON4, 0);
              break;
          }
          case IDC_BUTTON2:
          {
            memset(strn, 0, MAX_STRN);
            save_bmp_file(wind, strn);
            SendDlgItemMessage(wind, IDC_STATICTEXT1, WM_SETTEXT, 0, (int)&strn);
            break;
          }
          case IDC_BUTTON3:
          {
            check_for_redraw(wind);
            memset(strn, 0, MAX_STRN);
            check_file(strn, Fnam);
            SendDlgItemMessage(wind, IDC_STATICTEXT1, WM_SETTEXT, 0, (int)&strn);
            show_dft(wind, Fnam);
            break;
          }
          case IDC_BUTTON4:
          {
            check_for_redraw(wind);
            temp=SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_GETPOS, 0, 0);
            smin=SendDlgItemMessage(wind, IDC_SCROLLBAR2, SBM_GETPOS, 0, 0);
            memset(strn, 0, MAX_STRN);
            check_file(strn, Fnam);
            SendDlgItemMessage(wind, IDC_STATICTEXT1, WM_SETTEXT, 0, (int)&strn);
            show_data(wind, Fnam, temp, smin);
            break;
          }
          case IDC_BUTTON5:
          {
            check_for_redraw(wind);
            temp=get_best_width(wind, Fnam);
            SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_SETPOS, temp, TRUE);
            temp=SendDlgItemMessage(wind, IDC_SCROLLBAR1, SBM_GETPOS, 0, 0);
            sprintf(strn, "%d*\0\0", temp);
            SendDlgItemMessage(wind, IDC_STATICTEXT2, WM_SETTEXT, 0, (int)&strn);
            PostMessage(wind, WM_COMMAND, IDC_BUTTON4, 0);
            break;
          }
          case IDC_BUTTON6:
          {
            check_for_redraw(wind);
            show_stats(wind, Fnam);
            break;
          }
          default: return(FALSE);
        }
        break;
      }
      default: return(FALSE);
    }

    return(TRUE);
}


int WINAPI WinMain(HANDLE inst, HANDLE prev, LPSTR cmdl, int show)
// The program's entry point
{
    int  done;
    HWND hdlg;
    MSG  mesg;

    if(prev!=prev) Sleep(1); // stupid compiler errors about forced prototypes
    if(cmdl!=cmdl) Sleep(1); // stupid compiler errors about forced prototypes
    if(show!=show) Sleep(1); // stupid compiler errors about forced prototypes

    one_dft(0, 0, 0); // generate the sine and cosine tables

    if(get_filename(Fnam, 0)==FALSE) done=TRUE;
    else                             done=FALSE;

    if(done==FALSE)
    {
        hdlg=CreateDialog(inst, MAKEINTRESOURCE(IDD_DIALOG1), 0, (DLGPROC)dialog1);
        if(!hdlg)
        {
            done=TRUE;
            MessageBox(NULL, "Dialog 1 creation failed", "Error:", POP_MODE);
        }
        else PostMessage(hdlg, WM_COMMAND, IDC_BUTTON4, 0);
    }

    if(done==FALSE)
    {
        while(GetMessage(&mesg,NULL,0,0)>0)
        {
            TranslateMessage(&mesg);
            DispatchMessage(&mesg);
        }
    }

    return(TRUE);
}



/*---------------------------------------------------------------------------/*

                    GNU GENERAL PUBLIC LICENSE
                       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

                    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

                            NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.


                     END OF TERMS AND CONDITIONS

/*---------------------------------------------------------------------------*/
