// 196 Algorithm iteration checker, by Benjamin Despres, 07/26/2002
//
// I have distributed this program under the terms of the GPL v2.0,
// the text of which appears at the end of this file.  The text of
// the GPL MUST remain with all versions of this program, including
// any derivative works.  Moving it to its own file (usually named
// "copying") satisfies this requirement.
//
// Build this as a win32 CLI program.  It should work just as well
// in a GUI build if your compiler doesn't like CLIs, but you'll need
// to give stdout a meaning (and probably change main() to a WinMain(),
// not a problem since it only cares about one command-line argument,
// and an optional one at that).
//
// I specifically use Borland C++ 5.02 as my compiler, but I don't
// often use any funky Borland-isms.  Commenting out my use of
// MessageBox() and get_filename(), this should even build and run
// under Linux with no problems.



#include<time.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<windows.h>



#define POP_MODE (MB_OK|MB_TOPMOST|MB_APPLMODAL)

#define MAX_STRN (1024)

#define VERS_CHK "v2.566\0"



int verify_checksum(int val1, int val2, int iter)
{
    int i;
    int temp;
    int flag;

    flag=0;
    if(val1==0)
    {
        if(val1!=val2) flag=2;
    }
    else if((val1==3)||(val1==6))
    {
        temp=val1;
        for(i=0;i<(iter%2);i++) temp=((temp*2)%9);
        if(temp!=val2) flag=1;
        if((val2!=6)&&(val2!=3)) flag=2;
    }
    else
    {
        temp=val1;
        for(i=0;i<(iter%6);i++) temp=((temp*2)%9);
        if(temp!=val2) flag=1;
        if((val2==0)||(val2==3)||(val2==6)) flag=2;
    }

    return(flag);
}


unsigned short crc16(unsigned char data, unsigned short poly, unsigned short resl)
{
    int i;
    resl^=(unsigned short)(((unsigned short)data)<<8);
    for(i=8;i>0;--i)
    {
        if(resl&0x8000) resl=(unsigned short)((resl<<1)^poly);
        else            resl=(unsigned short)((resl<<1));
    }
    return (resl);
}


unsigned short file_crc16(char *fnam)
{
    FILE           *finp;
    unsigned char   crcd;
    unsigned short  crcr;

    if((finp=fopen(fnam,"rb"))==NULL)
    {
        printf("Error: Cannot open file \"%s\".\n", fnam);
        return(0xFFFF);
    }

    crcd='0'; crcr=0xFFFF;
    while((fread(&crcd,1,1,finp)==1)&&(crcd>=' '));
    while((fread(&crcd,1,1,finp)==1)&&(crcd>=' '));
    while(fread(&crcd,1,1,finp)==1) crcr=crc16(crcd, 0x1021, crcr);

    fclose(finp);

    return(crcr);
}


void check_file(char *fnam)
{
    FILE          *finp;
    int            i;
    int            iter;
    int            lmax;
    int            leng;
    int            csum;
    int            corg;
    int            crcv;
    unsigned char  data;
    char           dbeg[MAX_STRN];
    char           strn[MAX_STRN];

    crcv=file_crc16(fnam);

    if((finp=fopen(fnam,"rt"))==NULL)
    {
        printf("Error: Cannot open file \"%s\".\n", fnam);
        return;
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        printf("Error: Unexpected EOF encountered\n");
        return;
    }
    if(crcv!=(int)strtod(strn+16,NULL))
    {
        printf("Warning: Incorrect CRC-16 (%04X)", (int)strtod(strn+16,NULL));
        printf(" in file, should have %04X\n\n", crcv);
    }
    else printf("File has the correct CRC-16, %04X\n\n", crcv);

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        printf("Error: Unexpected EOF encountered\n");
        return;
    }
    for(i= 0;i<MAX_STRN;i++) dbeg[i]=0;
    for(i=18;i<MAX_STRN;i++) if((strn[i]<'0')||(strn[i]>'9')) break;
    corg=0; leng=i-1;
    for(i=leng;i>=18;i--)
    {
        dbeg[leng-i]=(char)(strn[i]);
        data=(char)(strn[i]-'0');
        corg=((corg+data)%9);
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        printf("Error: Unexpected EOF encountered\n");
        return;
    }
    iter=(int)strtod(strn+17, NULL);
    if(iter<0)
    {
        fclose(finp);
        printf("Error: Invalid iteration (%d) recorded in file.\n", iter);
        return;
    }

    if(fgets(strn,MAX_STRN-1,finp)==NULL)
    {
        fclose(finp);
        printf("Error: Unexpected EOF encountered\n");
        return;
    }
    lmax=(int)strtod(strn+17, NULL);
    if(lmax<0)
    {
        fclose(finp);
        printf("Error: Invalid length (%d) recorded in file.\n", lmax);
        return;
    }

    csum=0; leng=0;
    while(fgets(strn,MAX_STRN-1,finp)!=NULL)
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if((strn[i]<'0')||(strn[i]>'9')) break;
            data=(char)(strn[i]-'0');
            csum=((csum+data)%9);
            leng++;
        }
    }

    fclose(finp);

    if(leng!=lmax)
    {
        printf("Warning: Reported length (%d) ", lmax);
        printf("differs from actual length (%d)\n\n", leng);
    }
    else printf("Reported length (%d) equals actual length.\n\n", lmax, leng);


    csum=verify_checksum(corg, csum, iter);
    if(csum!=0)
    {
        printf("Warning: MOD-9 checksum (%d) failed - ", csum);
        printf("The stored %d-digit number\n         cannot ", leng);
        if(csum==1) printf("occur on the stored iteration (%d).\n", iter);
        if(csum==2) printf("result from the stored starting value (%s).\n", dbeg);
    }
    else printf("MOD-9 checksum (%d) passed.\n", csum);
}


int get_filename(char fnam[MAX_STRN])
{
    OPENFILENAME ofnm;
    DWORD        eror;

    fnam[0]=fnam[1]=0x00;

    ofnm.lStructSize       = sizeof(OPENFILENAME);
    ofnm.hwndOwner         = NULL;
    ofnm.hInstance         = NULL;
    ofnm.lpstrFilter       = "All Files\0*.*\0\0";
    ofnm.lpstrCustomFilter = NULL;
    ofnm.nMaxCustFilter    = 0;
    ofnm.nFilterIndex      = 1;
    ofnm.lpstrFile         = (LPSTR)fnam;
    ofnm.nMaxFile          = MAX_STRN;
    ofnm.lpstrFileTitle    = NULL;
    ofnm.nMaxFileTitle     = 0;
    ofnm.lpstrInitialDir   = NULL;
    ofnm.lpstrTitle        = "Open";
    ofnm.Flags             = OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST|OFN_READONLY;
    ofnm.nFileOffset       = 0;
    ofnm.nFileExtension    = 0;
    ofnm.lpstrDefExt       = "*";
    ofnm.lCustData         = 0L;
    ofnm.lpfnHook          = NULL;
    ofnm.lpTemplateName    = NULL;

    if(GetOpenFileName(&ofnm)!=TRUE)
    {
        eror=CommDlgExtendedError();
        if(eror!=0)
        {
            sprintf(fnam, "GetOpenFileName failed\n(error %d)", eror);
            MessageBox(NULL, fnam, "Error:", POP_MODE);
        }
        return(FALSE);
    }

    return(TRUE);
}


int main(int argc, char *argv[])
{
    int  i;
    char fnam[MAX_STRN];

    printf("\n\n");
    printf("196 Iteration Checker %s\n\n", VERS_CHK);

    if(argc<2) get_filename(fnam);
    else
    {
        for(i=0;i<MAX_STRN;i++)
        {
            if(argv[1][i]<=' ') break;
            fnam[i]=argv[1][i];
        }
        for(i=i;i<MAX_STRN;i++) fnam[i]=0;
    }

    printf("Checking Istvan-formatted 196 file");
    if(strlen(fnam)<30) printf(" \"%s\"...\n\n", fnam);
    else                printf("\n    \"%s\"...\n\n", fnam);

    check_file(fnam);

    printf("\n\n");
    return(TRUE);
}



/*---------------------------------------------------------------------------/*

                    GNU GENERAL PUBLIC LICENSE
                       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

                    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

                            NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.


                     END OF TERMS AND CONDITIONS

/*---------------------------------------------------------------------------*/

