// I have distributed this program under the terms of the GPL v2.0,
// the text of which appears at the end of this file.  The text of
// the GPL MUST remain with all versions of this program, including
// any derivative works.  Moving if to its own file (usually named
// "copying" satisfies this requirement.
//
// If you use this source (particularly the "faa8x64a" routine) or a
// trivial variant thereof, I ask that you give me credit for my work.
// Under the GPL, I cannot force that as a condition of using this
// code, but, since the active 196 community has relatively few people
// in it, I will trust mutual good will and at worst, peer-pressure,
// to encourage compliance with this request.
//
// I originally hesitated to release this as open source, because I
// feared it would do more harm than good.  If everyone just uses my
// flip-and-add function, or worse, trys numerous trivial tweaks to
// get an extra few percent performance out of the code, the 196
// community has gained nothing.  If you have no intention of writing
// your own optimized flip-and-add routine, then using mine *does*
// benefit us all, so go right ahead.  If you would otherwise have
// kept trying to beat me for speed, please, KEEP TRYING.  By all
// means take some ideas from what I've done (cache manipulation, MMX,
// alignment, etc), but you won't make any major improvements if you
// *start* with my code.
//
// Enjoy.
//
// Benjamin Despres, 06/28/2002
//
// PS - I compile this using Borland C++ 5.02, with TASM v5.3 as the
// assembler.  This does not exist as a standalone package (ie, BCC5
// does not come with TASM at all), so almost no one will have the
// ability to compile this "right out of the box".  If anyone would
// like to add an equivalent MSC6 (which I do not own) example, by
// all means feel free to do so, and I will gladly add the file to
// my web site.


/*This is a slightly modified version of Ben's work to allow it to compile
using Microsoft Visual Studio 6.0 and MASM. For best performance disable
optimizations under 'Project>Settings>Optimisations'.
Matt Stenson August 2003*/


#pragma optimize ("g",on)
#pragma pack (16)




#include<stdio.h>
#include<stdlib.h>
#include<windows.h>



#define MEM_INIT (1240)



int faa8x64a(void *dat1, void *dat2, int leng)
{
    const __int64 C0x0000000000000001 = 0x0000000000000001;
    const __int64 C0x0000000100000000 = 0x0000000100000000;
    const __int64 C0x0606060606060606 = 0x0606060606060606;
    const __int64 C0x0F0F0F0F0F0F0F0F = 0x0F0F0F0F0F0F0F0F;
    const __int64 C0x76F6F6F676F6F6F6 = 0x76F6F6F676F6F6F6;
    const __int64 C0x7FFFFFFF7FFFFFFF = 0x7FFFFFFF7FFFFFFF;
    __int64       flag                = 0xFFFFFFFFFFFFFFFF;

    _asm
    {
        // load start and end pointers, set 64 bit masks, and set carries to 0
        mov    edx,    [leng]
        mov    edi,    [dat1]
        mov    esi,    edx
        add    edx,    edi
        add    esi,    edi
        sub    edx,    32
        mov    ebx,    [dat2]
        mov    eax,    0
        pxor   mm7,    mm7
        nop
        nop
        nop

// start outer loop
faa0:
            // try to pre-cache the data for the next loop iteration
            mov    eax,    [edx-48]
            mov    eax,    [edi+48]

            // load next reversed section
            mov    eax,    [edx+24]
            mov    ecx,    [edx+28]
            bswap  eax
            bswap  ecx
            movd   mm1,    eax
            movd   mm0,    ecx
            mov    eax,    [edx+16]
            mov    ecx,    [edx+20]
            bswap  eax
            bswap  ecx
            movd   mm3,    eax
            movd   mm2,    ecx
            psllq  mm1,    32
            mov    eax,    [edx+ 8]
            mov    ecx,    [edx+12]
            bswap  eax
            bswap  ecx
            movd   mm5,    eax
            movd   mm4,    ecx
            psllq  mm3,    32
            por    mm0,    mm1
            mov    eax,    [edx   ]
            mov    ecx,    [edx+ 4]
            bswap  eax
            bswap  ecx
            movd   mm1,    eax
            movd   mm6,    ecx
            psllq  mm5,    32
            por    mm2,    mm3
            psllq  mm1,    32
            por    mm4,    mm5
            por    mm6,    mm1

            // load in-order portion of the number and do base addition
            paddd  mm0,    [edi]
            paddd  mm2,    [edi+8]
            paddd  mm4,    [edi+16]
            paddd  mm6,    [edi+24]
            sub    edx,    32
            paddd  mm0,    [C0x76F6F6F676F6F6F6]
            paddd  mm2,    [C0x76F6F6F676F6F6F6]
            paddd  mm4,    [C0x76F6F6F676F6F6F6]
            paddd  mm6,    [C0x76F6F6F676F6F6F6]
            paddd  mm0,    mm7
            add    edi,    32

            // check for serial interdependancies in the carries ( = 9999)
            movq   mm3,    mm2
            movq   mm5,    mm4
            movq   mm7,    mm6
            pcmpeqd mm3,   [C0x7FFFFFFF7FFFFFFF]
            pcmpeqd mm5,   [C0x7FFFFFFF7FFFFFFF]
            pcmpeqd mm7,   [C0x7FFFFFFF7FFFFFFF]
            por    mm3,    mm5
            por    mm5,    mm7
            por    mm3,    mm7
            por    mm5,    mm3
            psrlq  mm3,    32
            movd   eax,    mm5
            movd   ecx,    mm3
            or     ecx,    eax
            jnz    faa1

// do the fast, fully-serially-independant carry handling
            // take care of intra-qword carries (damned MMX, no full 64b add)
            movq   mm1,    mm0
            movq   mm3,    mm2
            movq   mm5,    mm4
            movq   mm7,    mm6
            psllq  mm1,    3
            psllq  mm3,    3
            psllq  mm5,    3
            psllq  mm7,    3
            pxor   mm1,    [C0x0000000100000000]
            pxor   mm3,    [C0x0000000100000000]
            pxor   mm5,    [C0x0000000100000000]
            pxor   mm7,    [C0x0000000100000000]
            pand   mm1,    [C0x0000000100000000]
            pand   mm3,    [C0x0000000100000000]
            pand   mm5,    [C0x0000000100000000]
            pand   mm7,    [C0x0000000100000000]
            paddd  mm0,    mm1
            paddd  mm2,    mm3
            paddd  mm4,    mm5
            paddd  mm6,    mm7
            // take care of inter-qword carries
            movq   mm1,    mm0
            movq   mm3,    mm2
            movq   mm5,    mm4
            movq   mm7,    mm6
            psrlq  mm1,    61
            psrlq  mm3,    61
            psrlq  mm5,    61
            psrlq  mm7,    61
            pxor   mm1,    [C0x0000000000000001]
            pxor   mm3,    [C0x0000000000000001]
            pxor   mm5,    [C0x0000000000000001]
            pxor   mm7,    [C0x0000000000000001]
            pand   mm1,    [C0x0000000000000001]
            pand   mm3,    [C0x0000000000000001]
            pand   mm5,    [C0x0000000000000001]
            pand   mm7,    [C0x0000000000000001]
            paddd  mm2,    mm1
            paddd  mm4,    mm3
            paddd  mm6,    mm5
            movd   eax,    mm7
            // okay, carries handled, go do the final steps
            jmp    faa2
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            nop

// need to do slow, fully-serially-dependant carry handling
faa1:
            // round 1, propagate carries through first qword
            movq   mm1,    mm0
            psllq  mm1,    3
            pxor   mm1,    [C0x0000000100000000]
            pand   mm1,    [C0x0000000100000000]
            paddd  mm0,    mm1
            movq   mm1,    mm0
            psrlq  mm1,    61
            pxor   mm1,    [C0x0000000000000001]
            pand   mm1,    [C0x0000000000000001]
            paddd  mm2,    mm1
            // round 2, propagate carries through second qword
            movq   mm3,    mm2
            psllq  mm3,    3
            pxor   mm3,    [C0x0000000100000000]
            pand   mm3,    [C0x0000000100000000]
            paddd  mm2,    mm3
            movq   mm3,    mm2
            psrlq  mm3,    61
            pxor   mm3,    [C0x0000000000000001]
            pand   mm3,    [C0x0000000000000001]
            paddd  mm4,    mm3
            // round 3, propagate carries through third qword
            movq   mm5,    mm4
            psllq  mm5,    3
            pxor   mm5,    [C0x0000000100000000]
            pand   mm5,    [C0x0000000100000000]
            paddd  mm4,    mm5
            movq   mm5,    mm4
            psrlq  mm5,    61
            pxor   mm5,    [C0x0000000000000001]
            pand   mm5,    [C0x0000000000000001]
            paddd  mm6,    mm5
            // round 4, propagate carries through fourth and final qword
            movq   mm7,    mm6
            psllq  mm7,    3
            pxor   mm7,    [C0x0000000100000000]
            pand   mm7,    [C0x0000000100000000]
            paddd  mm6,    mm7
            movq   mm7,    mm6
            psrlq  mm7,    61
            pxor   mm7,    [C0x0000000000000001]
            pand   mm7,    [C0x0000000000000001]
            movd   eax,     mm7
            // okay, carries handled, go do the final steps

// code common to both carry methods
faa2:
            // finish the set (subtract-6 fixup on no carry)
            movq   mm1,    mm0
            movq   mm3,    mm2
            movq   mm5,    mm4
            movq   mm7,    mm6
            psrld  mm1,    3
            psrld  mm3,    3
            psrld  mm5,    3
            psrld  mm7,    3
            pand   mm1,    [C0x0606060606060606]
            pand   mm3,    [C0x0606060606060606]
            pand   mm5,    [C0x0606060606060606]
            pand   mm7,    [C0x0606060606060606]
            psubd  mm0,    mm1
            psubd  mm2,    mm3
            psubd  mm4,    mm5
            psubd  mm6,    mm7
            pand   mm1,    mm3
            pand   mm5,    mm7
            pand   mm0,    [C0x0F0F0F0F0F0F0F0F]
            movq   mm7,    [flag]
            pand   mm2,    [C0x0F0F0F0F0F0F0F0F]
            pand   mm1,    mm5
            pand   mm4,    [C0x0F0F0F0F0F0F0F0F]
            pand   mm7,    mm1
            pand   mm6,    [C0x0F0F0F0F0F0F0F0F]
            movq   [flag], mm7
            // write it
            movq   [ebx],    mm0
            movq   [ebx+8],  mm2
            movq   [ebx+16], mm4
            movq   [ebx+24], mm6
            add    ebx,      32
            // do another pass if not done
            cmp    edi,      esi
            movd   mm7,      eax
            jle    faa0

// end of addition tidying up
        // zero the next few bytes of the output (future input) array
        pxor mm0, mm0
        movq   [ebx],    mm0
        movq   [ebx+8],  mm0
        movq   [ebx+16], mm0
        movq   [ebx+24], mm0
        movq   [ebx+32], mm0
        movq   [ebx+40], mm0
        movq   [ebx+48], mm0
        movq   [ebx+56], mm0
        movq   [ebx+64], mm0
        movq   [ebx+72], mm0
        movq   [ebx+80], mm0
        movq   [ebx+88], mm0
        // stupid intel FPU register hacks...
        emms
    }

    if(((char *)dat2)[leng]!=0) leng++;

    if(flag==C0x0606060606060606) return(-(leng+1));

    return(leng);
}


int set_number(char *data, char *nmbr)
// note that this leaves the number reversed, which doesn't matter at all.
{
    int i;

    for(i=0;i<1024;i++)
    {
        if((nmbr[i]<'0')||(nmbr[i]>'9')) break;
        data[i]=(char)(nmbr[i]-'0');
    }
    return(i);
}


int main(int argc, char *argv[])
{
    int     i;
    int     size;
    int     iter;
    char   *data;
    char   *dat1;
    char   *dpt1;
    char   *dat2;
    char   *dpt2;

    printf("\n\n");

    if(argc<2)
    {
        printf("Usage:  196xmpl.exe <starting number>\n\n\n");
        exit(0);
    }

    // get some memory, and well-aligned pointers with lots 'o padding
    dat1=(char *)malloc(MEM_INIT); dpt1=(char *)(((int)dat1+512)&0xFFFFFFC0);
    dat2=(char *)malloc(MEM_INIT); dpt2=(char *)(((int)dat2+512)&0xFFFFFFC0);

    if((dat1!=NULL)&&(dat2!=NULL))
    {
        for(i=0;i<MEM_INIT;i++) dat1[i]=0;
        for(i=0;i<MEM_INIT;i++) dat2[i]=0;
        size=set_number(dpt1, argv[1]);
        data=dpt1;
        iter=0;
        while((size>=0)&&(size<(MEM_INIT-1024)))
        {
            if((size>=0)&&(size<(MEM_INIT-1024)))
            {
                size=faa8x64a((void *)dpt1, (void *)dpt2, size);
                data=dpt2;
                iter++;
            }
            if((size>=0)&&(size<(MEM_INIT-1024)))
            {
                size=faa8x64a((void *)dpt2, (void *)dpt1, size);
                data=dpt1;
                iter++;
            }
        }
        printf("After %d iterations, \n", iter);
        if(size>=0)
        {
            printf("Maximum size reached with no palindrome:\n");
        }
        else
        {
            size=(-(size+1));
            printf("Palindrome of length %d reached:\n", size);
        }
        for(i=(size+(49-(size%50)));i>=0;i--)
        {
            printf("%01X", data[i]);
            if((i% 5)==0) printf(" ");
            if((i%50)==0) printf("\n");
        }
        printf("\n");
    }
    else printf("Something went wrong.  I think.  Help.\n");

    if(dat2!=NULL) free(dat2);
    if(dat1!=NULL) free(dat1);
    printf("\n\n");
    return(TRUE);
}



/*---------------------------------------------------------------------------/*

                    GNU GENERAL PUBLIC LICENSE
                       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
     59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

                            Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

                    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

                            NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.


                     END OF TERMS AND CONDITIONS

/*---------------------------------------------------------------------------*/

